package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedContextFluentImpl<T extends NamedContextFluent<T>> extends BaseFluent<T> implements NamedContextFluent<T>{

     VisitableBuilder<Context, ?> context;     String name;     Map<String, Object> additionalProperties = new HashMap();

    public Context getContext(){
    return this.context!=null?this.context.build():null;
    }
    public T withContext( Context context){
    if (context!=null){ this.context= new ContextBuilder(context); _visitables.add(this.context);} return (T) this;
    }
    public ContextNested<T> withNewContext(){
    return new ContextNestedImpl<T>();
    }
    public ContextNested<T> withNewContextLike( Context item){
    return new ContextNestedImpl<T>(item);
    }
    public ContextNested<T> editContext(){
    return withNewContextLike(getContext());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedContextFluentImpl that = (NamedContextFluentImpl) o;
if (context != null ? !context.equals(that.context) :that.context != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ContextNestedImpl<N> extends ContextFluentImpl<ContextNested<N>> implements ContextNested<N>{

        private final ContextBuilder builder;
    
             ContextNestedImpl (){
        this.builder = new ContextBuilder(this);
        }
             ContextNestedImpl ( Context item){
        this.builder = new ContextBuilder(this, item);
        }
    
            public N endContext(){
            return and();
        }
            public N and(){
            return (N) NamedContextFluentImpl.this.withContext(builder.build());
        }
    
}


}
