package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PersistentVolumeClaimSpecFluentImpl<T extends PersistentVolumeClaimSpecFluent<T>> extends BaseFluent<T> implements PersistentVolumeClaimSpecFluent<T>{

     List<String> accessModes = new ArrayList();     VisitableBuilder<ResourceRequirements, ?> resources;     String volumeName;     Map<String, Object> additionalProperties = new HashMap();

    public T addToAccessModes( String ...items){
    for (String item : items) {this.accessModes.add(item);} return (T)this;
    }
    public T removeFromAccessModes( String ...items){
    for (String item : items) {this.accessModes.remove(item);} return (T)this;
    }
    public List<String> getAccessModes(){
    return this.accessModes;
    }
    public T withAccessModes( List<String> accessModes){
    this.accessModes.clear();if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (T) this;
    }
    public T withAccessModes( String ...accessModes){
    this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (T) this;
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNestedImpl<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNestedImpl<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public String getVolumeName(){
    return this.volumeName;
    }
    public T withVolumeName( String volumeName){
    this.volumeName=volumeName; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl) o;
if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ResourcesNested<N>> implements ResourcesNested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNestedImpl ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
             ResourcesNestedImpl (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
    
            public N and(){
            return (N) PersistentVolumeClaimSpecFluentImpl.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}


}
