package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildSpecFluent<T extends BuildSpecFluent<T>> extends Fluent<T>{


    public BuildOutput getOutput();    public T withOutput( BuildOutput output);    public OutputNested<T> withNewOutput();    public OutputNested<T> withNewOutputLike( BuildOutput item);    public OutputNested<T> editOutput();    public ResourceRequirements getResources();    public T withResources( ResourceRequirements resources);    public ResourcesNested<T> withNewResources();    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<T> editResources();    public SourceRevision getRevision();    public T withRevision( SourceRevision revision);    public RevisionNested<T> withNewRevision();    public RevisionNested<T> withNewRevisionLike( SourceRevision item);    public RevisionNested<T> editRevision();    public String getServiceAccount();    public T withServiceAccount( String serviceAccount);    public BuildSource getSource();    public T withSource( BuildSource source);    public SourceNested<T> withNewSource();    public SourceNested<T> withNewSourceLike( BuildSource item);    public SourceNested<T> editSource();    public BuildStrategy getStrategy();    public T withStrategy( BuildStrategy strategy);    public StrategyNested<T> withNewStrategy();    public StrategyNested<T> withNewStrategyLike( BuildStrategy item);    public StrategyNested<T> editStrategy();    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface OutputNested<N> extends Nested<N>, BuildOutputFluent<OutputNested<N>>{
            public N endOutput();            public N and();        
}

    public interface ResourcesNested<N> extends Nested<N>, ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface RevisionNested<N> extends Nested<N>, SourceRevisionFluent<RevisionNested<N>>{
            public N endRevision();            public N and();        
}

    public interface SourceNested<N> extends Nested<N>, BuildSourceFluent<SourceNested<N>>{
            public N and();            public N endSource();        
}

    public interface StrategyNested<N> extends Nested<N>, BuildStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}


}
