package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeploymentStrategyFluentImpl<T extends DeploymentStrategyFluent<T>> extends BaseFluent<T> implements DeploymentStrategyFluent<T>{

     VisitableBuilder<CustomDeploymentStrategyParams, ?> customParams;     VisitableBuilder<RecreateDeploymentStrategyParams, ?> recreateParams;     VisitableBuilder<ResourceRequirements, ?> resources;     VisitableBuilder<RollingDeploymentStrategyParams, ?> rollingParams;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public CustomDeploymentStrategyParams getCustomParams(){
    return this.customParams!=null?this.customParams.build():null;
    }
    public T withCustomParams( CustomDeploymentStrategyParams customParams){
    if (customParams!=null){ this.customParams= new CustomDeploymentStrategyParamsBuilder(customParams); _visitables.add(this.customParams);} return (T) this;
    }
    public CustomParamsNested<T> withNewCustomParams(){
    return new CustomParamsNestedImpl<T>();
    }
    public CustomParamsNested<T> withNewCustomParamsLike( CustomDeploymentStrategyParams item){
    return new CustomParamsNestedImpl<T>(item);
    }
    public CustomParamsNested<T> editCustomParams(){
    return withNewCustomParamsLike(getCustomParams());
    }
    public RecreateDeploymentStrategyParams getRecreateParams(){
    return this.recreateParams!=null?this.recreateParams.build():null;
    }
    public T withRecreateParams( RecreateDeploymentStrategyParams recreateParams){
    if (recreateParams!=null){ this.recreateParams= new RecreateDeploymentStrategyParamsBuilder(recreateParams); _visitables.add(this.recreateParams);} return (T) this;
    }
    public RecreateParamsNested<T> withNewRecreateParams(){
    return new RecreateParamsNestedImpl<T>();
    }
    public RecreateParamsNested<T> withNewRecreateParamsLike( RecreateDeploymentStrategyParams item){
    return new RecreateParamsNestedImpl<T>(item);
    }
    public RecreateParamsNested<T> editRecreateParams(){
    return withNewRecreateParamsLike(getRecreateParams());
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public T withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (T) this;
    }
    public ResourcesNested<T> withNewResources(){
    return new ResourcesNestedImpl<T>();
    }
    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNestedImpl<T>(item);
    }
    public ResourcesNested<T> editResources(){
    return withNewResourcesLike(getResources());
    }
    public RollingDeploymentStrategyParams getRollingParams(){
    return this.rollingParams!=null?this.rollingParams.build():null;
    }
    public T withRollingParams( RollingDeploymentStrategyParams rollingParams){
    if (rollingParams!=null){ this.rollingParams= new RollingDeploymentStrategyParamsBuilder(rollingParams); _visitables.add(this.rollingParams);} return (T) this;
    }
    public RollingParamsNested<T> withNewRollingParams(){
    return new RollingParamsNestedImpl<T>();
    }
    public RollingParamsNested<T> withNewRollingParamsLike( RollingDeploymentStrategyParams item){
    return new RollingParamsNestedImpl<T>(item);
    }
    public RollingParamsNested<T> editRollingParams(){
    return withNewRollingParamsLike(getRollingParams());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentStrategyFluentImpl that = (DeploymentStrategyFluentImpl) o;
if (customParams != null ? !customParams.equals(that.customParams) :that.customParams != null) return false;
if (recreateParams != null ? !recreateParams.equals(that.recreateParams) :that.recreateParams != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (rollingParams != null ? !rollingParams.equals(that.rollingParams) :that.rollingParams != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CustomParamsNestedImpl<N> extends CustomDeploymentStrategyParamsFluentImpl<CustomParamsNested<N>> implements CustomParamsNested<N>{

        private final CustomDeploymentStrategyParamsBuilder builder;
    
             CustomParamsNestedImpl (){
        this.builder = new CustomDeploymentStrategyParamsBuilder(this);
        }
             CustomParamsNestedImpl ( CustomDeploymentStrategyParams item){
        this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
        }
    
            public N endCustomParams(){
            return and();
        }
            public N and(){
            return (N) DeploymentStrategyFluentImpl.this.withCustomParams(builder.build());
        }
    
}
    public class RecreateParamsNestedImpl<N> extends RecreateDeploymentStrategyParamsFluentImpl<RecreateParamsNested<N>> implements RecreateParamsNested<N>{

        private final RecreateDeploymentStrategyParamsBuilder builder;
    
             RecreateParamsNestedImpl (){
        this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
        }
             RecreateParamsNestedImpl ( RecreateDeploymentStrategyParams item){
        this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentStrategyFluentImpl.this.withRecreateParams(builder.build());
        }
            public N endRecreateParams(){
            return and();
        }
    
}
    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ResourcesNested<N>> implements ResourcesNested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNestedImpl (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNestedImpl ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentStrategyFluentImpl.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}
    public class RollingParamsNestedImpl<N> extends RollingDeploymentStrategyParamsFluentImpl<RollingParamsNested<N>> implements RollingParamsNested<N>{

        private final RollingDeploymentStrategyParamsBuilder builder;
    
             RollingParamsNestedImpl (){
        this.builder = new RollingDeploymentStrategyParamsBuilder(this);
        }
             RollingParamsNestedImpl ( RollingDeploymentStrategyParams item){
        this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentStrategyFluentImpl.this.withRollingParams(builder.build());
        }
            public N endRollingParams(){
            return and();
        }
    
}


}
