package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ImageFluent<T extends ImageFluent<T>> extends Fluent<T>{


    public Image.ApiVersion getApiVersion();    public T withApiVersion( Image.ApiVersion apiVersion);    public String getDockerImageManifest();    public T withDockerImageManifest( String dockerImageManifest);    public HasMetadata getDockerImageMetadata();    public T withDockerImageMetadata( HasMetadata dockerImageMetadata);    public String getDockerImageMetadataVersion();    public T withDockerImageMetadataVersion( String dockerImageMetadataVersion);    public String getDockerImageReference();    public T withDockerImageReference( String dockerImageReference);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
