package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ProjectListFluent<T extends ProjectListFluent<T>> extends Fluent<T>{


    public ProjectList.ApiVersion getApiVersion();    public T withApiVersion( ProjectList.ApiVersion apiVersion);    public T addToItems( Project ...items);    public T removeFromItems( Project ...items);    public List<Project> getItems();    public T withItems( List<Project> items);    public T withItems( Project ...items);    public ItemsNested<T> addNewItem();    public ItemsNested<T> addNewItemLike( Project item);    public String getKind();    public T withKind( String kind);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ItemsNested<N> extends Nested<N>, ProjectFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
