package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class SourceBuildStrategyBuilder extends SourceBuildStrategyFluentImpl<SourceBuildStrategyBuilder> implements VisitableBuilder<SourceBuildStrategy,SourceBuildStrategyBuilder>{

     SourceBuildStrategyFluent<?> fluent;
public SourceBuildStrategyBuilder(){
    this(new SourceBuildStrategy());
}
public SourceBuildStrategyBuilder( SourceBuildStrategyFluent<?> fluent ){
    this(fluent, new SourceBuildStrategy());
}
public SourceBuildStrategyBuilder( SourceBuildStrategyFluent<?> fluent , SourceBuildStrategy instance ){
    this.fluent = fluent; fluent.withEnv(instance.getEnv()); fluent.withForcePull(instance.getForcePull()); fluent.withFrom(instance.getFrom()); fluent.withIncremental(instance.getIncremental()); fluent.withPullSecret(instance.getPullSecret()); fluent.withScripts(instance.getScripts()); 
}
public SourceBuildStrategyBuilder( SourceBuildStrategy instance ){
    this.fluent = this; this.withEnv(instance.getEnv()); this.withForcePull(instance.getForcePull()); this.withFrom(instance.getFrom()); this.withIncremental(instance.getIncremental()); this.withPullSecret(instance.getPullSecret()); this.withScripts(instance.getScripts()); 
}

public EditableSourceBuildStrategy build(){
    EditableSourceBuildStrategy buildable = new EditableSourceBuildStrategy(fluent.getEnv(),fluent.isForcePull(),fluent.getFrom(),fluent.isIncremental(),fluent.getPullSecret(),fluent.getScripts());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SourceBuildStrategyBuilder that = (SourceBuildStrategyBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
