package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class EndpointAddressFluentImpl<T extends EndpointAddressFluent<T>> extends BaseFluent<T> implements EndpointAddressFluent<T>{

     String ip;     VisitableBuilder<ObjectReference, ?> targetRef;     Map<String, Object> additionalProperties = new HashMap();

    public String getIp(){
    return this.ip;
    }
    public T withIp( String ip){
    this.ip=ip; return (T) this;
    }
    public ObjectReference getTargetRef(){
    return this.targetRef!=null?this.targetRef.build():null;
    }
    public T withTargetRef( ObjectReference targetRef){
    if (targetRef!=null){ this.targetRef= new ObjectReferenceBuilder(targetRef); _visitables.add(this.targetRef);} return (T) this;
    }
    public TargetRefNested<T> withNewTargetRef(){
    return new TargetRefNestedImpl<T>();
    }
    public TargetRefNested<T> withNewTargetRefLike( ObjectReference item){
    return new TargetRefNestedImpl<T>(item);
    }
    public TargetRefNested<T> editTargetRef(){
    return withNewTargetRefLike(getTargetRef());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointAddressFluentImpl that = (EndpointAddressFluentImpl) o;
if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
if (targetRef != null ? !targetRef.equals(that.targetRef) :that.targetRef != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class TargetRefNestedImpl<N> extends ObjectReferenceFluentImpl<TargetRefNested<N>> implements TargetRefNested<N>{

        private final ObjectReferenceBuilder builder;
    
             TargetRefNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             TargetRefNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N endTargetRef(){
            return and();
        }
            public N and(){
            return (N) EndpointAddressFluentImpl.this.withTargetRef(builder.build());
        }
    
}


}
