package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class EndpointsFluentImpl<T extends EndpointsFluent<T>> extends BaseFluent<T> implements EndpointsFluent<T>{

     Endpoints.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<EndpointSubset, ?>> subsets = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Endpoints.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Endpoints.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToSubsets( EndpointSubset ...items){
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (T)this;
    }
    public T removeFromSubsets( EndpointSubset ...items){
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.remove(builder);this.subsets.remove(builder);} return (T)this;
    }
    public List<EndpointSubset> getSubsets(){
    return build(subsets);
    }
    public T withSubsets( List<EndpointSubset> subsets){
    this.subsets.clear();if (subsets != null) {for (EndpointSubset item : subsets){this.addToSubsets(item);}} return (T) this;
    }
    public T withSubsets( EndpointSubset ...subsets){
    this.subsets.clear(); if (subsets != null) {for (EndpointSubset item :subsets){ this.addToSubsets(item);}} return (T) this;
    }
    public SubsetsNested<T> addNewSubset(){
    return new SubsetsNestedImpl<T>();
    }
    public SubsetsNested<T> addNewSubsetLike( EndpointSubset item){
    return new SubsetsNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointsFluentImpl that = (EndpointsFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) EndpointsFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SubsetsNestedImpl<N> extends EndpointSubsetFluentImpl<SubsetsNested<N>> implements SubsetsNested<N>{

        private final EndpointSubsetBuilder builder;
    
             SubsetsNestedImpl (){
        this.builder = new EndpointSubsetBuilder(this);
        }
             SubsetsNestedImpl ( EndpointSubset item){
        this.builder = new EndpointSubsetBuilder(this, item);
        }
    
            public N and(){
            return (N) EndpointsFluentImpl.this.addToSubsets(builder.build());
        }
            public N endSubset(){
            return and();
        }
    
}


}
