package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeploymentTriggerPolicyFluentImpl<T extends DeploymentTriggerPolicyFluent<T>> extends BaseFluent<T> implements DeploymentTriggerPolicyFluent<T>{

     VisitableBuilder<DeploymentTriggerImageChangeParams, ?> imageChangeParams;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public DeploymentTriggerImageChangeParams getImageChangeParams(){
    return this.imageChangeParams!=null?this.imageChangeParams.build():null;
    }
    public T withImageChangeParams( DeploymentTriggerImageChangeParams imageChangeParams){
    if (imageChangeParams!=null){ this.imageChangeParams= new DeploymentTriggerImageChangeParamsBuilder(imageChangeParams); _visitables.add(this.imageChangeParams);} return (T) this;
    }
    public ImageChangeParamsNested<T> withNewImageChangeParams(){
    return new ImageChangeParamsNestedImpl<T>();
    }
    public ImageChangeParamsNested<T> withNewImageChangeParamsLike( DeploymentTriggerImageChangeParams item){
    return new ImageChangeParamsNestedImpl<T>(item);
    }
    public ImageChangeParamsNested<T> editImageChangeParams(){
    return withNewImageChangeParamsLike(getImageChangeParams());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentTriggerPolicyFluentImpl that = (DeploymentTriggerPolicyFluentImpl) o;
if (imageChangeParams != null ? !imageChangeParams.equals(that.imageChangeParams) :that.imageChangeParams != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ImageChangeParamsNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<ImageChangeParamsNested<N>> implements ImageChangeParamsNested<N>{

        private final DeploymentTriggerImageChangeParamsBuilder builder;
    
             ImageChangeParamsNestedImpl (){
        this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
        }
             ImageChangeParamsNestedImpl ( DeploymentTriggerImageChangeParams item){
        this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentTriggerPolicyFluentImpl.this.withImageChangeParams(builder.build());
        }
            public N endImageChangeParams(){
            return and();
        }
    
}


}
