package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class IdentityBuilder extends IdentityFluentImpl<IdentityBuilder> implements VisitableBuilder<Identity,IdentityBuilder>{

     IdentityFluent<?> fluent;
public IdentityBuilder(){
    this(new Identity());
}
public IdentityBuilder( IdentityFluent<?> fluent ){
    this(fluent, new Identity());
}
public IdentityBuilder( IdentityFluent<?> fluent , Identity instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withExtra(instance.getExtra()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withProviderName(instance.getProviderName()); fluent.withProviderUserName(instance.getProviderUserName()); fluent.withUser(instance.getUser()); 
}
public IdentityBuilder( Identity instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withExtra(instance.getExtra()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withProviderName(instance.getProviderName()); this.withProviderUserName(instance.getProviderUserName()); this.withUser(instance.getUser()); 
}

public EditableIdentity build(){
    EditableIdentity buildable = new EditableIdentity(fluent.getApiVersion(),fluent.getExtra(),fluent.getKind(),fluent.getMetadata(),fluent.getProviderName(),fluent.getProviderUserName(),fluent.getUser());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
IdentityBuilder that = (IdentityBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
