package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class AuthInfoBuilder extends AuthInfoFluentImpl<AuthInfoBuilder> implements VisitableBuilder<AuthInfo,AuthInfoBuilder>{

     AuthInfoFluent<?> fluent;
public AuthInfoBuilder(){
    this(new AuthInfo());
}
public AuthInfoBuilder( AuthInfoFluent<?> fluent ){
    this(fluent, new AuthInfo());
}
public AuthInfoBuilder( AuthInfoFluent<?> fluent , AuthInfo instance ){
    this.fluent = fluent; fluent.withClientCertificate(instance.getClientCertificate()); fluent.withClientCertificateData(instance.getClientCertificateData()); fluent.withClientKey(instance.getClientKey()); fluent.withClientKeyData(instance.getClientKeyData()); fluent.withExtensions(instance.getExtensions()); fluent.withPassword(instance.getPassword()); fluent.withToken(instance.getToken()); fluent.withUsername(instance.getUsername()); 
}
public AuthInfoBuilder( AuthInfo instance ){
    this.fluent = this; this.withClientCertificate(instance.getClientCertificate()); this.withClientCertificateData(instance.getClientCertificateData()); this.withClientKey(instance.getClientKey()); this.withClientKeyData(instance.getClientKeyData()); this.withExtensions(instance.getExtensions()); this.withPassword(instance.getPassword()); this.withToken(instance.getToken()); this.withUsername(instance.getUsername()); 
}

public EditableAuthInfo build(){
    EditableAuthInfo buildable = new EditableAuthInfo(fluent.getClientCertificate(),fluent.getClientCertificateData(),fluent.getClientKey(),fluent.getClientKeyData(),fluent.getExtensions(),fluent.getPassword(),fluent.getToken(),fluent.getUsername());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
AuthInfoBuilder that = (AuthInfoBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
