package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ISCSIVolumeSourceFluentImpl<T extends ISCSIVolumeSourceFluent<T>> extends BaseFluent<T> implements ISCSIVolumeSourceFluent<T>{

     String fsType;     String iqn;     Integer lun;     Boolean readOnly;     String targetPortal;     Map<String, Object> additionalProperties = new HashMap();

    public String getFsType(){
    return this.fsType;
    }
    public T withFsType( String fsType){
    this.fsType=fsType; return (T) this;
    }
    public String getIqn(){
    return this.iqn;
    }
    public T withIqn( String iqn){
    this.iqn=iqn; return (T) this;
    }
    public Integer getLun(){
    return this.lun;
    }
    public T withLun( Integer lun){
    this.lun=lun; return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public String getTargetPortal(){
    return this.targetPortal;
    }
    public T withTargetPortal( String targetPortal){
    this.targetPortal=targetPortal; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ISCSIVolumeSourceFluentImpl that = (ISCSIVolumeSourceFluentImpl) o;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (iqn != null ? !iqn.equals(that.iqn) :that.iqn != null) return false;
if (lun != null ? !lun.equals(that.lun) :that.lun != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (targetPortal != null ? !targetPortal.equals(that.targetPortal) :that.targetPortal != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
