package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class SecurityContextConstraintsFluentImpl<T extends SecurityContextConstraintsFluent<T>> extends BaseFluent<T> implements SecurityContextConstraintsFluent<T>{

     Boolean allowHostDirVolumePlugin;     Boolean allowHostNetwork;     Boolean allowHostPorts;     Boolean allowPrivilegedContainer;     List<String> allowedCapabilities = new ArrayList();     SecurityContextConstraints.ApiVersion apiVersion;     List<String> groups = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<RunAsUserStrategyOptions, ?> runAsUser;     VisitableBuilder<SELinuxContextStrategyOptions, ?> seLinuxContext;     List<String> users = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Boolean isAllowHostDirVolumePlugin(){
    return this.allowHostDirVolumePlugin;
    }
    public T withAllowHostDirVolumePlugin( Boolean allowHostDirVolumePlugin){
    this.allowHostDirVolumePlugin=allowHostDirVolumePlugin; return (T) this;
    }
    public Boolean isAllowHostNetwork(){
    return this.allowHostNetwork;
    }
    public T withAllowHostNetwork( Boolean allowHostNetwork){
    this.allowHostNetwork=allowHostNetwork; return (T) this;
    }
    public Boolean isAllowHostPorts(){
    return this.allowHostPorts;
    }
    public T withAllowHostPorts( Boolean allowHostPorts){
    this.allowHostPorts=allowHostPorts; return (T) this;
    }
    public Boolean isAllowPrivilegedContainer(){
    return this.allowPrivilegedContainer;
    }
    public T withAllowPrivilegedContainer( Boolean allowPrivilegedContainer){
    this.allowPrivilegedContainer=allowPrivilegedContainer; return (T) this;
    }
    public T addToAllowedCapabilities( String ...items){
    for (String item : items) {this.allowedCapabilities.add(item);} return (T)this;
    }
    public T removeFromAllowedCapabilities( String ...items){
    for (String item : items) {this.allowedCapabilities.remove(item);} return (T)this;
    }
    public List<String> getAllowedCapabilities(){
    return this.allowedCapabilities;
    }
    public T withAllowedCapabilities( List<String> allowedCapabilities){
    this.allowedCapabilities.clear();if (allowedCapabilities != null) {for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} return (T) this;
    }
    public T withAllowedCapabilities( String ...allowedCapabilities){
    this.allowedCapabilities.clear(); if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (T) this;
    }
    public SecurityContextConstraints.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( SecurityContextConstraints.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (T)this;
    }
    public T removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (T)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public T withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (T) this;
    }
    public T withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public RunAsUserStrategyOptions getRunAsUser(){
    return this.runAsUser!=null?this.runAsUser.build():null;
    }
    public T withRunAsUser( RunAsUserStrategyOptions runAsUser){
    if (runAsUser!=null){ this.runAsUser= new RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.add(this.runAsUser);} return (T) this;
    }
    public RunAsUserNested<T> withNewRunAsUser(){
    return new RunAsUserNestedImpl<T>();
    }
    public RunAsUserNested<T> withNewRunAsUserLike( RunAsUserStrategyOptions item){
    return new RunAsUserNestedImpl<T>(item);
    }
    public RunAsUserNested<T> editRunAsUser(){
    return withNewRunAsUserLike(getRunAsUser());
    }
    public T withNewRunAsUser( String type,  Long uid,  Long uidRangeMax,  Long uidRangeMin){
    return withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }
    public SELinuxContextStrategyOptions getSeLinuxContext(){
    return this.seLinuxContext!=null?this.seLinuxContext.build():null;
    }
    public T withSeLinuxContext( SELinuxContextStrategyOptions seLinuxContext){
    if (seLinuxContext!=null){ this.seLinuxContext= new SELinuxContextStrategyOptionsBuilder(seLinuxContext); _visitables.add(this.seLinuxContext);} return (T) this;
    }
    public SeLinuxContextNested<T> withNewSeLinuxContext(){
    return new SeLinuxContextNestedImpl<T>();
    }
    public SeLinuxContextNested<T> withNewSeLinuxContextLike( SELinuxContextStrategyOptions item){
    return new SeLinuxContextNestedImpl<T>(item);
    }
    public SeLinuxContextNested<T> editSeLinuxContext(){
    return withNewSeLinuxContextLike(getSeLinuxContext());
    }
    public T addToUsers( String ...items){
    for (String item : items) {this.users.add(item);} return (T)this;
    }
    public T removeFromUsers( String ...items){
    for (String item : items) {this.users.remove(item);} return (T)this;
    }
    public List<String> getUsers(){
    return this.users;
    }
    public T withUsers( List<String> users){
    this.users.clear();if (users != null) {for (String item : users){this.addToUsers(item);}} return (T) this;
    }
    public T withUsers( String ...users){
    this.users.clear(); if (users != null) {for (String item :users){ this.addToUsers(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl) o;
if (allowHostDirVolumePlugin != null ? !allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) :that.allowHostDirVolumePlugin != null) return false;
if (allowHostNetwork != null ? !allowHostNetwork.equals(that.allowHostNetwork) :that.allowHostNetwork != null) return false;
if (allowHostPorts != null ? !allowHostPorts.equals(that.allowHostPorts) :that.allowHostPorts != null) return false;
if (allowPrivilegedContainer != null ? !allowPrivilegedContainer.equals(that.allowPrivilegedContainer) :that.allowPrivilegedContainer != null) return false;
if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
if (seLinuxContext != null ? !seLinuxContext.equals(that.seLinuxContext) :that.seLinuxContext != null) return false;
if (users != null ? !users.equals(that.users) :that.users != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RunAsUserNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<RunAsUserNested<N>> implements RunAsUserNested<N>{

        private final RunAsUserStrategyOptionsBuilder builder;
    
             RunAsUserNestedImpl (){
        this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }
             RunAsUserNestedImpl ( RunAsUserStrategyOptions item){
        this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }
    
            public N endRunAsUser(){
            return and();
        }
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withRunAsUser(builder.build());
        }
    
}
    public class SeLinuxContextNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<SeLinuxContextNested<N>> implements SeLinuxContextNested<N>{

        private final SELinuxContextStrategyOptionsBuilder builder;
    
             SeLinuxContextNestedImpl (){
        this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }
             SeLinuxContextNestedImpl ( SELinuxContextStrategyOptions item){
        this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(builder.build());
        }
            public N endSeLinuxContext(){
            return and();
        }
    
}


}
