package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class ImageFluentImpl<T extends ImageFluent<T>> extends BaseFluent<T> implements ImageFluent<T>{

     Image.ApiVersion apiVersion;     String dockerImageManifest;     HasMetadata dockerImageMetadata;     String dockerImageMetadataVersion;     String dockerImageReference;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public Image.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Image.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getDockerImageManifest(){
    return this.dockerImageManifest;
    }
    public T withDockerImageManifest( String dockerImageManifest){
    this.dockerImageManifest=dockerImageManifest; return (T) this;
    }
    public HasMetadata getDockerImageMetadata(){
    return this.dockerImageMetadata;
    }
    public T withDockerImageMetadata( HasMetadata dockerImageMetadata){
    this.dockerImageMetadata=dockerImageMetadata; return (T) this;
    }
    public String getDockerImageMetadataVersion(){
    return this.dockerImageMetadataVersion;
    }
    public T withDockerImageMetadataVersion( String dockerImageMetadataVersion){
    this.dockerImageMetadataVersion=dockerImageMetadataVersion; return (T) this;
    }
    public String getDockerImageReference(){
    return this.dockerImageReference;
    }
    public T withDockerImageReference( String dockerImageReference){
    this.dockerImageReference=dockerImageReference; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageFluentImpl that = (ImageFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (dockerImageManifest != null ? !dockerImageManifest.equals(that.dockerImageManifest) :that.dockerImageManifest != null) return false;
if (dockerImageMetadata != null ? !dockerImageMetadata.equals(that.dockerImageMetadata) :that.dockerImageMetadata != null) return false;
if (dockerImageMetadataVersion != null ? !dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) :that.dockerImageMetadataVersion != null) return false;
if (dockerImageReference != null ? !dockerImageReference.equals(that.dockerImageReference) :that.dockerImageReference != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ImageFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
