/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointsFluentImpl<T extends EndpointsFluent<T>>
extends BaseFluent<T>
implements EndpointsFluent<T> {
    Endpoints.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<EndpointSubset, ?>> subsets = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Endpoints.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Endpoints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public EndpointsFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EndpointsFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EndpointsFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T addToSubsets(EndpointSubset ... items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.add(builder);
            this.subsets.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromSubsets(EndpointSubset ... items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.remove(builder);
            this.subsets.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<EndpointSubset> getSubsets() {
        return this.build(this.subsets);
    }

    @Override
    public T withSubsets(List<EndpointSubset> subsets) {
        this.subsets.clear();
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSubsets(EndpointSubset ... subsets) {
        this.subsets.clear();
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (T)this;
    }

    @Override
    public EndpointsFluent.SubsetsNested<T> addNewSubset() {
        return new SubsetsNestedImpl();
    }

    @Override
    public EndpointsFluent.SubsetsNested<T> addNewSubsetLike(EndpointSubset item) {
        return new SubsetsNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointsFluentImpl that = (EndpointsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.subsets != null ? !this.subsets.equals(that.subsets) : that.subsets != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SubsetsNestedImpl<N>
    extends EndpointSubsetFluentImpl<EndpointsFluent.SubsetsNested<N>>
    implements EndpointsFluent.SubsetsNested<N> {
        private final EndpointSubsetBuilder builder;

        SubsetsNestedImpl() {
            this.builder = new EndpointSubsetBuilder(this);
        }

        SubsetsNestedImpl(EndpointSubset item) {
            this.builder = new EndpointSubsetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.addToSubsets(this.builder.build());
        }

        @Override
        public N endSubset() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EndpointsFluent.MetadataNested<N>>
    implements EndpointsFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

