/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableEnvVar;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EnvVarBuilder
extends EnvVarFluentImpl<EnvVarBuilder>
implements VisitableBuilder<EnvVar, EnvVarBuilder> {
    EnvVarFluent<?> fluent;

    public EnvVarBuilder() {
        this(new EnvVar());
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent) {
        this(fluent, new EnvVar());
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
    }

    public EnvVarBuilder(EnvVar instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
    }

    @Override
    public EditableEnvVar build() {
        EditableEnvVar buildable = new EditableEnvVar(this.fluent.getName(), this.fluent.getValue(), this.fluent.getValueFrom());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarBuilder that = (EnvVarBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

