/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import java.util.HashMap;
import java.util.Map;

public class ReplicationControllerSpecFluentImpl<T extends ReplicationControllerSpecFluent<T>>
extends BaseFluent<T>
implements ReplicationControllerSpecFluent<T> {
    Integer replicas;
    Map<String, String> selector = new HashMap<String, String>();
    VisitableBuilder<PodTemplateSpec, ?> template;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public T withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (T)this;
    }

    @Override
    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)this;
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public T withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (T)this;
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<T> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<T> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<T> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationControllerSpecFluentImpl that = (ReplicationControllerSpecFluentImpl)o;
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<ReplicationControllerSpecFluent.TemplateNested<N>>
    implements ReplicationControllerSpecFluent.TemplateNested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N endTemplate() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ReplicationControllerSpecFluentImpl.this.withTemplate(this.builder.build());
        }
    }
}

