package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PersistentVolumeClaimSpecFluent<T extends PersistentVolumeClaimSpecFluent<T>> extends Fluent<T>{


    public T addToAccessModes( String ...items);    public T removeFromAccessModes( String ...items);    public List<String> getAccessModes();    public T withAccessModes( List<String> accessModes);    public T withAccessModes( String ...accessModes);    public ResourceRequirements getResources();    public T withResources( ResourceRequirements resources);    public ResourcesNested<T> withNewResources();    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<T> editResources();    public String getVolumeName();    public T withVolumeName( String volumeName);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ResourcesNested<N> extends Nested<N>, ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}


}
