package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class PolicyRuleBuilder extends PolicyRuleFluentImpl<PolicyRuleBuilder> implements VisitableBuilder<PolicyRule,PolicyRuleBuilder>{

     PolicyRuleFluent<?> fluent;
public PolicyRuleBuilder(){
    this(new PolicyRule());
}
public PolicyRuleBuilder( PolicyRuleFluent<?> fluent ){
    this(fluent, new PolicyRule());
}
public PolicyRuleBuilder( PolicyRuleFluent<?> fluent , PolicyRule instance ){
    this.fluent = fluent; fluent.withAttributeRestrictions(instance.getAttributeRestrictions()); fluent.withNonResourceURLs(instance.getNonResourceURLs()); fluent.withResourceNames(instance.getResourceNames()); fluent.withResources(instance.getResources()); fluent.withVerbs(instance.getVerbs()); 
}
public PolicyRuleBuilder( PolicyRule instance ){
    this.fluent = this; this.withAttributeRestrictions(instance.getAttributeRestrictions()); this.withNonResourceURLs(instance.getNonResourceURLs()); this.withResourceNames(instance.getResourceNames()); this.withResources(instance.getResources()); this.withVerbs(instance.getVerbs()); 
}

public EditablePolicyRule build(){
    EditablePolicyRule buildable = new EditablePolicyRule(fluent.getAttributeRestrictions(),fluent.getNonResourceURLs(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PolicyRuleBuilder that = (PolicyRuleBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
