package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class LifecycleFluentImpl<T extends LifecycleFluent<T>> extends BaseFluent<T> implements LifecycleFluent<T>{

     VisitableBuilder<Handler, ?> postStart;     VisitableBuilder<Handler, ?> preStop;     Map<String, Object> additionalProperties = new HashMap();
public LifecycleFluentImpl(){
    
}
public LifecycleFluentImpl( Lifecycle instance ){
    this.withPostStart(instance.getPostStart()); this.withPreStop(instance.getPreStop()); 
}

    public Handler getPostStart(){
    return this.postStart!=null?this.postStart.build():null;
    }
    public T withPostStart( Handler postStart){
    if (postStart!=null){ this.postStart= new HandlerBuilder(postStart); _visitables.add(this.postStart);} return (T) this;
    }
    public PostStartNested<T> withNewPostStart(){
    return new PostStartNestedImpl<T>();
    }
    public PostStartNested<T> withNewPostStartLike( Handler item){
    return new PostStartNestedImpl<T>(item);
    }
    public PostStartNested<T> editPostStart(){
    return withNewPostStartLike(getPostStart());
    }
    public Handler getPreStop(){
    return this.preStop!=null?this.preStop.build():null;
    }
    public T withPreStop( Handler preStop){
    if (preStop!=null){ this.preStop= new HandlerBuilder(preStop); _visitables.add(this.preStop);} return (T) this;
    }
    public PreStopNested<T> withNewPreStop(){
    return new PreStopNestedImpl<T>();
    }
    public PreStopNested<T> withNewPreStopLike( Handler item){
    return new PreStopNestedImpl<T>(item);
    }
    public PreStopNested<T> editPreStop(){
    return withNewPreStopLike(getPreStop());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LifecycleFluentImpl that = (LifecycleFluentImpl) o;
if (postStart != null ? !postStart.equals(that.postStart) :that.postStart != null) return false;
if (preStop != null ? !preStop.equals(that.preStop) :that.preStop != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PostStartNestedImpl<N> extends HandlerFluentImpl<PostStartNested<N>> implements PostStartNested<N>{

        private final HandlerBuilder builder;
    
             PostStartNestedImpl (){
        this.builder = new HandlerBuilder(this);
        }
             PostStartNestedImpl ( Handler item){
        this.builder = new HandlerBuilder(this, item);
        }
    
            public N endPostStart(){
            return and();
        }
            public N and(){
            return (N) LifecycleFluentImpl.this.withPostStart(builder.build());
        }
    
}
    public class PreStopNestedImpl<N> extends HandlerFluentImpl<PreStopNested<N>> implements PreStopNested<N>{

        private final HandlerBuilder builder;
    
             PreStopNestedImpl (){
        this.builder = new HandlerBuilder(this);
        }
             PreStopNestedImpl ( Handler item){
        this.builder = new HandlerBuilder(this, item);
        }
    
            public N and(){
            return (N) LifecycleFluentImpl.this.withPreStop(builder.build());
        }
            public N endPreStop(){
            return and();
        }
    
}


}
