
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "level",
    "role",
    "type",
    "user"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class SELinuxOptions {

    /**
     * the level label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     */
    @JsonProperty("level")
    private String level;
    /**
     * the role label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     */
    @JsonProperty("role")
    private String role;
    /**
     * the type label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     */
    @JsonProperty("type")
    private String type;
    /**
     * the user label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     */
    @JsonProperty("user")
    private String user;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SELinuxOptions() {
    }

    /**
     * 
     * @param role
     * @param level
     * @param type
     * @param user
     */
    public SELinuxOptions(String level, String role, String type, String user) {
        this.level = level;
        this.role = role;
        this.type = type;
        this.user = user;
    }

    /**
     * the level label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @return
     *     The level
     */
    @JsonProperty("level")
    public String getLevel() {
        return level;
    }

    /**
     * the level label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @param level
     *     The level
     */
    @JsonProperty("level")
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * the role label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @return
     *     The role
     */
    @JsonProperty("role")
    public String getRole() {
        return role;
    }

    /**
     * the role label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @param role
     *     The role
     */
    @JsonProperty("role")
    public void setRole(String role) {
        this.role = role;
    }

    /**
     * the type label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * the type label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * the user label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @return
     *     The user
     */
    @JsonProperty("user")
    public String getUser() {
        return user;
    }

    /**
     * the user label to apply to the container; see http://releases.k8s.io/HEAD/docs/user-guide/labels.md
     * 
     * @param user
     *     The user
     */
    @JsonProperty("user")
    public void setUser(String user) {
        this.user = user;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
