/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class HorizontalPodAutoscalerFluentImpl<T extends HorizontalPodAutoscalerFluent<T>>
extends BaseFluent<T>
implements HorizontalPodAutoscalerFluent<T> {
    HorizontalPodAutoscaler.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<HorizontalPodAutoscalerSpec, ?> spec;
    VisitableBuilder<HorizontalPodAutoscalerStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public HorizontalPodAutoscalerFluentImpl() {
    }

    public HorizontalPodAutoscalerFluentImpl(HorizontalPodAutoscaler instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public HorizontalPodAutoscaler.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(HorizontalPodAutoscaler.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public HorizontalPodAutoscalerSpec getSpec() {
        return this.spec != null ? (HorizontalPodAutoscalerSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(HorizontalPodAutoscalerSpec spec) {
        if (spec != null) {
            this.spec = new HorizontalPodAutoscalerSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerFluent.SpecNested<T> withNewSpecLike(HorizontalPodAutoscalerSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public HorizontalPodAutoscalerStatus getStatus() {
        return this.status != null ? (HorizontalPodAutoscalerStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(HorizontalPodAutoscalerStatus status) {
        if (status != null) {
            this.status = new HorizontalPodAutoscalerStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerFluent.StatusNested<T> withNewStatusLike(HorizontalPodAutoscalerStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T withNewStatus(Integer currentCPUUtilizationPercentage, Integer currentReplicas, Integer desiredReplicas, String lastScaleTime, Long observedGeneration) {
        return this.withStatus(new HorizontalPodAutoscalerStatus(currentCPUUtilizationPercentage, currentReplicas, desiredReplicas, lastScaleTime, observedGeneration));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerFluentImpl that = (HorizontalPodAutoscalerFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerFluent.StatusNested<N>>
    implements HorizontalPodAutoscalerFluent.StatusNested<N> {
        private final HorizontalPodAutoscalerStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new HorizontalPodAutoscalerStatusBuilder(this);
        }

        StatusNestedImpl(HorizontalPodAutoscalerStatus item) {
            this.builder = new HorizontalPodAutoscalerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerFluent.SpecNested<N>>
    implements HorizontalPodAutoscalerFluent.SpecNested<N> {
        private final HorizontalPodAutoscalerSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new HorizontalPodAutoscalerSpecBuilder(this);
        }

        SpecNestedImpl(HorizontalPodAutoscalerSpec item) {
            this.builder = new HorizontalPodAutoscalerSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<HorizontalPodAutoscalerFluent.MetadataNested<N>>
    implements HorizontalPodAutoscalerFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

