/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.NamedTagReference;
import io.fabric8.openshift.api.model.NamedTagReferenceBuilder;
import io.fabric8.openshift.api.model.NamedTagReferenceFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageStreamSpecFluentImpl<T extends ImageStreamSpecFluent<T>>
extends BaseFluent<T>
implements ImageStreamSpecFluent<T> {
    String dockerImageRepository;
    List<VisitableBuilder<NamedTagReference, ?>> tags = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageStreamSpecFluentImpl() {
    }

    public ImageStreamSpecFluentImpl(ImageStreamSpec instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withTags(instance.getTags());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public T withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (T)this;
    }

    @Override
    public T addToTags(NamedTagReference ... items) {
        for (NamedTagReference item : items) {
            NamedTagReferenceBuilder builder = new NamedTagReferenceBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromTags(NamedTagReference ... items) {
        for (NamedTagReference item : items) {
            NamedTagReferenceBuilder builder = new NamedTagReferenceBuilder(item);
            this._visitables.remove(builder);
            this.tags.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedTagReference> getTags() {
        return this.build(this.tags);
    }

    @Override
    public T withTags(List<NamedTagReference> tags) {
        this.tags.clear();
        if (tags != null) {
            for (NamedTagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withTags(NamedTagReference ... tags) {
        this.tags.clear();
        if (tags != null) {
            for (NamedTagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (T)this;
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<T> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<T> addNewTagLike(NamedTagReference item) {
        return new TagsNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TagsNestedImpl<N>
    extends NamedTagReferenceFluentImpl<ImageStreamSpecFluent.TagsNested<N>>
    implements ImageStreamSpecFluent.TagsNested<N> {
        private final NamedTagReferenceBuilder builder;

        TagsNestedImpl() {
            this.builder = new NamedTagReferenceBuilder(this);
        }

        TagsNestedImpl(NamedTagReference item) {
            this.builder = new NamedTagReferenceBuilder(this, item);
        }

        @Override
        public N endTag() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamSpecFluentImpl.this.addToTags(this.builder.build());
        }
    }
}

