package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class FlexVolumeSourceFluentImpl<T extends FlexVolumeSourceFluent<T>> extends BaseFluent<T> implements FlexVolumeSourceFluent<T>{

     String driver;     String fsType;     Map<String, String> options = new HashMap();     Boolean readOnly;     VisitableBuilder<LocalObjectReference, ?> secretRef;     Map<String, Object> additionalProperties = new HashMap();
public FlexVolumeSourceFluentImpl(){
    
}
public FlexVolumeSourceFluentImpl( FlexVolumeSource instance ){
    this.withDriver(instance.getDriver()); this.withFsType(instance.getFsType()); this.withOptions(instance.getOptions()); this.withReadOnly(instance.getReadOnly()); this.withSecretRef(instance.getSecretRef()); 
}

    public String getDriver(){
    return this.driver;
    }
    public T withDriver( String driver){
    this.driver=driver; return (T) this;
    }
    public String getFsType(){
    return this.fsType;
    }
    public T withFsType( String fsType){
    this.fsType=fsType; return (T) this;
    }
    public T addToOptions( String key,  String value){
    if(key != null && value != null) {this.options.put(key, value);} return (T)this;
    }
    public T addToOptions( Map<String, String> map){
    if(map != null) { this.options.putAll(map);} return (T)this;
    }
    public T removeFromOptions( String key){
    if(key != null) {this.options.remove(key);} return (T)this;
    }
    public T removeFromOptions( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.options.remove(key);}} return (T)this;
    }
    public Map<String, String> getOptions(){
    return this.options;
    }
    public T withOptions( Map<String, String> options){
    this.options.clear();if (options != null) {this.options.putAll(options);} return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public LocalObjectReference getSecretRef(){
    return this.secretRef!=null?this.secretRef.build():null;
    }
    public T withSecretRef( LocalObjectReference secretRef){
    if (secretRef!=null){ this.secretRef= new LocalObjectReferenceBuilder(secretRef); _visitables.add(this.secretRef);} return (T) this;
    }
    public SecretRefNested<T> withNewSecretRef(){
    return new SecretRefNestedImpl<T>();
    }
    public SecretRefNested<T> withNewSecretRefLike( LocalObjectReference item){
    return new SecretRefNestedImpl<T>(item);
    }
    public SecretRefNested<T> editSecretRef(){
    return withNewSecretRefLike(getSecretRef());
    }
    public T withNewSecretRef( String name){
    return withSecretRef(new LocalObjectReference(name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
FlexVolumeSourceFluentImpl that = (FlexVolumeSourceFluentImpl) o;
if (driver != null ? !driver.equals(that.driver) :that.driver != null) return false;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (options != null ? !options.equals(that.options) :that.options != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretRefNested<N>> implements SecretRefNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SecretRefNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
             SecretRefNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
    
            public N endSecretRef(){
            return and();
        }
            public N and(){
            return (N) FlexVolumeSourceFluentImpl.this.withSecretRef(builder.build());
        }
    
}


}
