package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeStatusFluent<T extends NodeStatusFluent<T>> extends Fluent<T>{


    public T addToAddresses( NodeAddress ...items);    public T removeFromAddresses( NodeAddress ...items);    public List<NodeAddress> getAddresses();    public T withAddresses( List<NodeAddress> addresses);    public T withAddresses( NodeAddress ...addresses);    public AddressesNested<T> addNewAddresse();    public AddressesNested<T> addNewAddresseLike( NodeAddress item);    public T addNewAddresse( String address,  String type);    public T addToAllocatable( String key,  Quantity value);    public T addToAllocatable( Map<String, Quantity> map);    public T removeFromAllocatable( String key);    public T removeFromAllocatable( Map<String, Quantity> map);    public Map<String, Quantity> getAllocatable();    public T withAllocatable( Map<String, Quantity> allocatable);    public T addToCapacity( String key,  Quantity value);    public T addToCapacity( Map<String, Quantity> map);    public T removeFromCapacity( String key);    public T removeFromCapacity( Map<String, Quantity> map);    public Map<String, Quantity> getCapacity();    public T withCapacity( Map<String, Quantity> capacity);    public T addToConditions( NodeCondition ...items);    public T removeFromConditions( NodeCondition ...items);    public List<NodeCondition> getConditions();    public T withConditions( List<NodeCondition> conditions);    public T withConditions( NodeCondition ...conditions);    public ConditionsNested<T> addNewCondition();    public ConditionsNested<T> addNewConditionLike( NodeCondition item);    public NodeDaemonEndpoints getDaemonEndpoints();    public T withDaemonEndpoints( NodeDaemonEndpoints daemonEndpoints);    public DaemonEndpointsNested<T> withNewDaemonEndpoints();    public DaemonEndpointsNested<T> withNewDaemonEndpointsLike( NodeDaemonEndpoints item);    public DaemonEndpointsNested<T> editDaemonEndpoints();    public T addToImages( ContainerImage ...items);    public T removeFromImages( ContainerImage ...items);    public List<ContainerImage> getImages();    public T withImages( List<ContainerImage> images);    public T withImages( ContainerImage ...images);    public ImagesNested<T> addNewImage();    public ImagesNested<T> addNewImageLike( ContainerImage item);    public NodeSystemInfo getNodeInfo();    public T withNodeInfo( NodeSystemInfo nodeInfo);    public NodeInfoNested<T> withNewNodeInfo();    public NodeInfoNested<T> withNewNodeInfoLike( NodeSystemInfo item);    public NodeInfoNested<T> editNodeInfo();    public String getPhase();    public T withPhase( String phase);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AddressesNested<N> extends Nested<N>, NodeAddressFluent<AddressesNested<N>>{
            public N and();            public N endAddresse();        
}

    public interface ConditionsNested<N> extends Nested<N>, NodeConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}

    public interface DaemonEndpointsNested<N> extends Nested<N>, NodeDaemonEndpointsFluent<DaemonEndpointsNested<N>>{
            public N endDaemonEndpoints();            public N and();        
}

    public interface ImagesNested<N> extends Nested<N>, ContainerImageFluent<ImagesNested<N>>{
            public N and();            public N endImage();        
}

    public interface NodeInfoNested<N> extends Nested<N>, NodeSystemInfoFluent<NodeInfoNested<N>>{
            public N and();            public N endNodeInfo();        
}


}
