package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class SecretKeySelectorFluentImpl<T extends SecretKeySelectorFluent<T>> extends BaseFluent<T> implements SecretKeySelectorFluent<T>{

     String key;     String name;     Map<String, Object> additionalProperties = new HashMap();
public SecretKeySelectorFluentImpl(){
    
}
public SecretKeySelectorFluentImpl( SecretKeySelector instance ){
    this.withKey(instance.getKey()); this.withName(instance.getName()); 
}

    public String getKey(){
    return this.key;
    }
    public T withKey( String key){
    this.key=key; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecretKeySelectorFluentImpl that = (SecretKeySelectorFluentImpl) o;
if (key != null ? !key.equals(that.key) :that.key != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
