package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class DaemonSetSpecFluentImpl<T extends DaemonSetSpecFluent<T>> extends BaseFluent<T> implements DaemonSetSpecFluent<T>{

     VisitableBuilder<LabelSelector, ?> selector;     VisitableBuilder<PodTemplateSpec, ?> template;     String uniqueLabelKey;     VisitableBuilder<DaemonSetUpdateStrategy, ?> updateStrategy;     Map<String, Object> additionalProperties = new HashMap();
public DaemonSetSpecFluentImpl(){
    
}
public DaemonSetSpecFluentImpl( DaemonSetSpec instance ){
    this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); this.withUniqueLabelKey(instance.getUniqueLabelKey()); this.withUpdateStrategy(instance.getUpdateStrategy()); 
}

    public LabelSelector getSelector(){
    return this.selector!=null?this.selector.build():null;
    }
    public T withSelector( LabelSelector selector){
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (T) this;
    }
    public SelectorNested<T> withNewSelector(){
    return new SelectorNestedImpl<T>();
    }
    public SelectorNested<T> withNewSelectorLike( LabelSelector item){
    return new SelectorNestedImpl<T>(item);
    }
    public SelectorNested<T> editSelector(){
    return withNewSelectorLike(getSelector());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNestedImpl<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public String getUniqueLabelKey(){
    return this.uniqueLabelKey;
    }
    public T withUniqueLabelKey( String uniqueLabelKey){
    this.uniqueLabelKey=uniqueLabelKey; return (T) this;
    }
    public DaemonSetUpdateStrategy getUpdateStrategy(){
    return this.updateStrategy!=null?this.updateStrategy.build():null;
    }
    public T withUpdateStrategy( DaemonSetUpdateStrategy updateStrategy){
    if (updateStrategy!=null){ this.updateStrategy= new DaemonSetUpdateStrategyBuilder(updateStrategy); _visitables.add(this.updateStrategy);} return (T) this;
    }
    public UpdateStrategyNested<T> withNewUpdateStrategy(){
    return new UpdateStrategyNestedImpl<T>();
    }
    public UpdateStrategyNested<T> withNewUpdateStrategyLike( DaemonSetUpdateStrategy item){
    return new UpdateStrategyNestedImpl<T>(item);
    }
    public UpdateStrategyNested<T> editUpdateStrategy(){
    return withNewUpdateStrategyLike(getUpdateStrategy());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl) o;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
if (uniqueLabelKey != null ? !uniqueLabelKey.equals(that.uniqueLabelKey) :that.uniqueLabelKey != null) return false;
if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<SelectorNested<N>> implements SelectorNested<N>{

        private final LabelSelectorBuilder builder;
    
             SelectorNestedImpl (){
        this.builder = new LabelSelectorBuilder(this);
        }
             SelectorNestedImpl ( LabelSelector item){
        this.builder = new LabelSelectorBuilder(this, item);
        }
    
            public N endSelector(){
            return and();
        }
            public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withSelector(builder.build());
        }
    
}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
        }
    
}
    public class UpdateStrategyNestedImpl<N> extends DaemonSetUpdateStrategyFluentImpl<UpdateStrategyNested<N>> implements UpdateStrategyNested<N>{

        private final DaemonSetUpdateStrategyBuilder builder;
    
             UpdateStrategyNestedImpl (){
        this.builder = new DaemonSetUpdateStrategyBuilder(this);
        }
             UpdateStrategyNestedImpl ( DaemonSetUpdateStrategy item){
        this.builder = new DaemonSetUpdateStrategyBuilder(this, item);
        }
    
            public N endUpdateStrategy(){
            return and();
        }
            public N and(){
            return (N) DaemonSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
        }
    
}


}
