package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class IngressBackendBuilder extends IngressBackendFluentImpl<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,IngressBackendBuilder>{

     IngressBackendFluent<?> fluent;
public IngressBackendBuilder(){
    this(new IngressBackend());
}
public IngressBackendBuilder( IngressBackendFluent<?> fluent ){
    this(fluent, new IngressBackend());
}
public IngressBackendBuilder( IngressBackendFluent<?> fluent , IngressBackend instance ){
    this.fluent = fluent; fluent.withServiceName(instance.getServiceName()); fluent.withServicePort(instance.getServicePort()); 
}
public IngressBackendBuilder( IngressBackend instance ){
    this.fluent = this; this.withServiceName(instance.getServiceName()); this.withServicePort(instance.getServicePort()); 
}

public EditableIngressBackend build(){
    EditableIngressBackend buildable = new EditableIngressBackend(fluent.getServiceName(),fluent.getServicePort());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
IngressBackendBuilder that = (IngressBackendBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
