package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ThirdPartyResourceFluent<T extends ThirdPartyResourceFluent<T>> extends Fluent<T>{


    public ThirdPartyResource.ApiVersion getApiVersion();    public T withApiVersion( ThirdPartyResource.ApiVersion apiVersion);    public String getDescription();    public T withDescription( String description);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToVersions( APIVersion ...items);    public T removeFromVersions( APIVersion ...items);    public List<APIVersion> getVersions();    public T withVersions( List<APIVersion> versions);    public T withVersions( APIVersion ...versions);    public VersionsNested<T> addNewVersion();    public VersionsNested<T> addNewVersionLike( APIVersion item);    public T addNewVersion( String apiGroup,  String name);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface VersionsNested<N> extends Nested<N>, APIVersionFluent<VersionsNested<N>>{
            public N and();            public N endVersion();        
}


}
