package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class BuildStatusBuilder extends BuildStatusFluentImpl<BuildStatusBuilder> implements VisitableBuilder<BuildStatus,BuildStatusBuilder>{

     BuildStatusFluent<?> fluent;
public BuildStatusBuilder(){
    this(new BuildStatus());
}
public BuildStatusBuilder( BuildStatusFluent<?> fluent ){
    this(fluent, new BuildStatus());
}
public BuildStatusBuilder( BuildStatusFluent<?> fluent , BuildStatus instance ){
    this.fluent = fluent; fluent.withCancelled(instance.getCancelled()); fluent.withCompletionTimestamp(instance.getCompletionTimestamp()); fluent.withConfig(instance.getConfig()); fluent.withDuration(instance.getDuration()); fluent.withMessage(instance.getMessage()); fluent.withOutputDockerImageReference(instance.getOutputDockerImageReference()); fluent.withPhase(instance.getPhase()); fluent.withReason(instance.getReason()); fluent.withStartTimestamp(instance.getStartTimestamp()); 
}
public BuildStatusBuilder( BuildStatus instance ){
    this.fluent = this; this.withCancelled(instance.getCancelled()); this.withCompletionTimestamp(instance.getCompletionTimestamp()); this.withConfig(instance.getConfig()); this.withDuration(instance.getDuration()); this.withMessage(instance.getMessage()); this.withOutputDockerImageReference(instance.getOutputDockerImageReference()); this.withPhase(instance.getPhase()); this.withReason(instance.getReason()); this.withStartTimestamp(instance.getStartTimestamp()); 
}

public EditableBuildStatus build(){
    EditableBuildStatus buildable = new EditableBuildStatus(fluent.isCancelled(),fluent.getCompletionTimestamp(),fluent.getConfig(),fluent.getDuration(),fluent.getMessage(),fluent.getOutputDockerImageReference(),fluent.getPhase(),fluent.getReason(),fluent.getStartTimestamp());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildStatusBuilder that = (BuildStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
