package io.fabric8.openshift.api.model;

import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public class IdentityFluentImpl<T extends IdentityFluent<T>> extends BaseFluent<T> implements IdentityFluent<T>{

     Identity.ApiVersion apiVersion;     Map<String, String> extra = new HashMap();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     String providerName;     String providerUserName;     VisitableBuilder<ObjectReference, ?> user;     Map<String, Object> additionalProperties = new HashMap();
public IdentityFluentImpl(){
    
}
public IdentityFluentImpl( Identity instance ){
    this.withApiVersion(instance.getApiVersion()); this.withExtra(instance.getExtra()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withProviderName(instance.getProviderName()); this.withProviderUserName(instance.getProviderUserName()); this.withUser(instance.getUser()); 
}

    public Identity.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Identity.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToExtra( String key,  String value){
    if(key != null && value != null) {this.extra.put(key, value);} return (T)this;
    }
    public T addToExtra( Map<String, String> map){
    if(map != null) { this.extra.putAll(map);} return (T)this;
    }
    public T removeFromExtra( String key){
    if(key != null) {this.extra.remove(key);} return (T)this;
    }
    public T removeFromExtra( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.extra.remove(key);}} return (T)this;
    }
    public Map<String, String> getExtra(){
    return this.extra;
    }
    public T withExtra( Map<String, String> extra){
    this.extra.clear();if (extra != null) {this.extra.putAll(extra);} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getProviderName(){
    return this.providerName;
    }
    public T withProviderName( String providerName){
    this.providerName=providerName; return (T) this;
    }
    public String getProviderUserName(){
    return this.providerUserName;
    }
    public T withProviderUserName( String providerUserName){
    this.providerUserName=providerUserName; return (T) this;
    }
    public ObjectReference getUser(){
    return this.user!=null?this.user.build():null;
    }
    public T withUser( ObjectReference user){
    if (user!=null){ this.user= new ObjectReferenceBuilder(user); _visitables.add(this.user);} return (T) this;
    }
    public UserNested<T> withNewUser(){
    return new UserNestedImpl<T>();
    }
    public UserNested<T> withNewUserLike( ObjectReference item){
    return new UserNestedImpl<T>(item);
    }
    public UserNested<T> editUser(){
    return withNewUserLike(getUser());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IdentityFluentImpl that = (IdentityFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (providerName != null ? !providerName.equals(that.providerName) :that.providerName != null) return false;
if (providerUserName != null ? !providerUserName.equals(that.providerUserName) :that.providerUserName != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) IdentityFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class UserNestedImpl<N> extends ObjectReferenceFluentImpl<UserNested<N>> implements UserNested<N>{

        private final ObjectReferenceBuilder builder;
    
             UserNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             UserNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) IdentityFluentImpl.this.withUser(builder.build());
        }
            public N endUser(){
            return and();
        }
    
}


}
