package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedTagEventListFluentImpl<T extends NamedTagEventListFluent<T>> extends BaseFluent<T> implements NamedTagEventListFluent<T>{

     List<VisitableBuilder<TagEventCondition, ?>> conditions = new ArrayList();     List<VisitableBuilder<TagEvent, ?>> items = new ArrayList();     String tag;     Map<String, Object> additionalProperties = new HashMap();
public NamedTagEventListFluentImpl(){
    
}
public NamedTagEventListFluentImpl( NamedTagEventList instance ){
    this.withConditions(instance.getConditions()); this.withItems(instance.getItems()); this.withTag(instance.getTag()); 
}

    public T addToConditions( TagEventCondition ...items){
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (T)this;
    }
    public T removeFromConditions( TagEventCondition ...items){
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (T)this;
    }
    public List<TagEventCondition> getConditions(){
    return build(conditions);
    }
    public T withConditions( List<TagEventCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (TagEventCondition item : conditions){this.addToConditions(item);}} return (T) this;
    }
    public T withConditions( TagEventCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (TagEventCondition item :conditions){ this.addToConditions(item);}} return (T) this;
    }
    public ConditionsNested<T> addNewCondition(){
    return new ConditionsNestedImpl<T>();
    }
    public ConditionsNested<T> addNewConditionLike( TagEventCondition item){
    return new ConditionsNestedImpl<T>(item);
    }
    public T addToItems( TagEvent ...items){
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public T removeFromItems( TagEvent ...items){
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (T)this;
    }
    public List<TagEvent> getItems(){
    return build(items);
    }
    public T withItems( List<TagEvent> items){
    this.items.clear();if (items != null) {for (TagEvent item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( TagEvent ...items){
    this.items.clear(); if (items != null) {for (TagEvent item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNestedImpl<T>();
    }
    public ItemsNested<T> addNewItemLike( TagEvent item){
    return new ItemsNestedImpl<T>(item);
    }
    public T addNewItem( String created,  String dockerImageReference,  Long generation,  String image){
    return addToItems(new TagEvent(created, dockerImageReference, generation, image));
    }
    public String getTag(){
    return this.tag;
    }
    public T withTag( String tag){
    this.tag=tag; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedTagEventListFluentImpl that = (NamedTagEventListFluentImpl) o;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends TagEventConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final TagEventConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new TagEventConditionBuilder(this);
        }
             ConditionsNestedImpl ( TagEventCondition item){
        this.builder = new TagEventConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) NamedTagEventListFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class ItemsNestedImpl<N> extends TagEventFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final TagEventBuilder builder;
    
             ItemsNestedImpl (){
        this.builder = new TagEventBuilder(this);
        }
             ItemsNestedImpl ( TagEvent item){
        this.builder = new TagEventBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) NamedTagEventListFluentImpl.this.addToItems(builder.build());
        }
    
}


}
