package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public interface SecretSpecFluent<T extends SecretSpecFluent<T>> extends Fluent<T>{


    public String getMountPath();    public T withMountPath( String mountPath);    public LocalObjectReference getSecretSource();    public T withSecretSource( LocalObjectReference secretSource);    public SecretSourceNested<T> withNewSecretSource();    public SecretSourceNested<T> withNewSecretSourceLike( LocalObjectReference item);    public SecretSourceNested<T> editSecretSource();    public T withNewSecretSource( String name);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SecretSourceNested<N> extends Nested<N>, LocalObjectReferenceFluent<SecretSourceNested<N>>{
            public N endSecretSource();            public N and();        
}


}
