package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PodTemplateFluent<T extends PodTemplateFluent<T>> extends Fluent<T>{


    public PodTemplate.ApiVersion getApiVersion();    public T withApiVersion( PodTemplate.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public PodTemplateSpec getTemplate();    public T withTemplate( PodTemplateSpec template);    public TemplateNested<T> withNewTemplate();    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item);    public TemplateNested<T> editTemplate();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface TemplateNested<N> extends Nested<N>, PodTemplateSpecFluent<TemplateNested<N>>{
            public N endTemplate();            public N and();        
}


}
