package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ConfigMapFluent<T extends ConfigMapFluent<T>> extends Fluent<T>{


    public ConfigMap.ApiVersion getApiVersion();    public T withApiVersion( ConfigMap.ApiVersion apiVersion);    public T addToData( String key,  String value);    public T addToData( Map<String, String> map);    public T removeFromData( String key);    public T removeFromData( Map<String, String> map);    public Map<String, String> getData();    public T withData( Map<String, String> data);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
