package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class DeploymentSpecBuilder extends DeploymentSpecFluentImpl<DeploymentSpecBuilder> implements VisitableBuilder<DeploymentSpec,DeploymentSpecBuilder>{

     DeploymentSpecFluent<?> fluent;
public DeploymentSpecBuilder(){
    this(new DeploymentSpec());
}
public DeploymentSpecBuilder( DeploymentSpecFluent<?> fluent ){
    this(fluent, new DeploymentSpec());
}
public DeploymentSpecBuilder( DeploymentSpecFluent<?> fluent , DeploymentSpec instance ){
    this.fluent = fluent; fluent.withPaused(instance.getPaused()); fluent.withReplicas(instance.getReplicas()); fluent.withSelector(instance.getSelector()); fluent.withStrategy(instance.getStrategy()); fluent.withTemplate(instance.getTemplate()); fluent.withUniqueLabelKey(instance.getUniqueLabelKey()); 
}
public DeploymentSpecBuilder( DeploymentSpec instance ){
    this.fluent = this; this.withPaused(instance.getPaused()); this.withReplicas(instance.getReplicas()); this.withSelector(instance.getSelector()); this.withStrategy(instance.getStrategy()); this.withTemplate(instance.getTemplate()); this.withUniqueLabelKey(instance.getUniqueLabelKey()); 
}

public EditableDeploymentSpec build(){
    EditableDeploymentSpec buildable = new EditableDeploymentSpec(fluent.isPaused(),fluent.getReplicas(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate(),fluent.getUniqueLabelKey());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeploymentSpecBuilder that = (DeploymentSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
