package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class BuildPostCommitSpecBuilder extends BuildPostCommitSpecFluentImpl<BuildPostCommitSpecBuilder> implements VisitableBuilder<BuildPostCommitSpec,BuildPostCommitSpecBuilder>{

     BuildPostCommitSpecFluent<?> fluent;
public BuildPostCommitSpecBuilder(){
    this(new BuildPostCommitSpec());
}
public BuildPostCommitSpecBuilder( BuildPostCommitSpecFluent<?> fluent ){
    this(fluent, new BuildPostCommitSpec());
}
public BuildPostCommitSpecBuilder( BuildPostCommitSpecFluent<?> fluent , BuildPostCommitSpec instance ){
    this.fluent = fluent; fluent.withArgs(instance.getArgs()); fluent.withCommand(instance.getCommand()); fluent.withScript(instance.getScript()); 
}
public BuildPostCommitSpecBuilder( BuildPostCommitSpec instance ){
    this.fluent = this; this.withArgs(instance.getArgs()); this.withCommand(instance.getCommand()); this.withScript(instance.getScript()); 
}

public EditableBuildPostCommitSpec build(){
    EditableBuildPostCommitSpec buildable = new EditableBuildPostCommitSpec(fluent.getArgs(),fluent.getCommand(),fluent.getScript());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildPostCommitSpecBuilder that = (BuildPostCommitSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
