/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableEnvVarSource;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EnvVarSourceBuilder
extends EnvVarSourceFluentImpl<EnvVarSourceBuilder>
implements VisitableBuilder<EnvVarSource, EnvVarSourceBuilder> {
    EnvVarSourceFluent<?> fluent;

    public EnvVarSourceBuilder() {
        this(new EnvVarSource());
    }

    public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent) {
        this(fluent, new EnvVarSource());
    }

    public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent, EnvVarSource instance) {
        this.fluent = fluent;
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        fluent.withFieldRef(instance.getFieldRef());
        fluent.withSecretKeyRef(instance.getSecretKeyRef());
    }

    public EnvVarSourceBuilder(EnvVarSource instance) {
        this.fluent = this;
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        this.withFieldRef(instance.getFieldRef());
        this.withSecretKeyRef(instance.getSecretKeyRef());
    }

    @Override
    public EditableEnvVarSource build() {
        EditableEnvVarSource buildable = new EditableEnvVarSource(this.fluent.getConfigMapKeyRef(), this.fluent.getFieldRef(), this.fluent.getSecretKeyRef());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarSourceBuilder that = (EnvVarSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

