/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageBuilder;
import io.fabric8.kubernetes.api.model.ContainerImageFluentImpl;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressBuilder;
import io.fabric8.kubernetes.api.model.NodeAddressFluentImpl;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionBuilder;
import io.fabric8.kubernetes.api.model.NodeConditionFluentImpl;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeStatusFluentImpl<T extends NodeStatusFluent<T>>
extends BaseFluent<T>
implements NodeStatusFluent<T> {
    List<VisitableBuilder<NodeAddress, ?>> addresses = new ArrayList();
    Map<String, Quantity> allocatable = new HashMap<String, Quantity>();
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    List<VisitableBuilder<NodeCondition, ?>> conditions = new ArrayList();
    VisitableBuilder<NodeDaemonEndpoints, ?> daemonEndpoints;
    List<VisitableBuilder<ContainerImage, ?>> images = new ArrayList();
    VisitableBuilder<NodeSystemInfo, ?> nodeInfo;
    String phase;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public NodeStatusFluentImpl() {
    }

    public NodeStatusFluentImpl(NodeStatus instance) {
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
    }

    @Override
    public T addToAddresses(NodeAddress ... items) {
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromAddresses(NodeAddress ... items) {
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.remove(builder);
            this.addresses.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NodeAddress> getAddresses() {
        return this.build(this.addresses);
    }

    @Override
    public T withAddresses(List<NodeAddress> addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withAddresses(NodeAddress ... addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public NodeStatusFluent.AddressesNested<T> addNewAddresse() {
        return new AddressesNestedImpl();
    }

    @Override
    public NodeStatusFluent.AddressesNested<T> addNewAddresseLike(NodeAddress item) {
        return new AddressesNestedImpl(item);
    }

    @Override
    public T addNewAddresse(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    @Override
    public T addToAllocatable(String key, Quantity value) {
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAllocatable(Map<String, Quantity> map) {
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAllocatable(String key) {
        if (key != null) {
            this.allocatable.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAllocatable(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.allocatable.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    @Override
    public T withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable.clear();
        if (allocatable != null) {
            this.allocatable.putAll(allocatable);
        }
        return (T)this;
    }

    @Override
    public T addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.capacity.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public T withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (T)this;
    }

    @Override
    public T addToConditions(NodeCondition ... items) {
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromConditions(NodeCondition ... items) {
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NodeCondition> getConditions() {
        return this.build(this.conditions);
    }

    @Override
    public T withConditions(List<NodeCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withConditions(NodeCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    @Override
    public NodeStatusFluent.ConditionsNested<T> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public NodeStatusFluent.ConditionsNested<T> addNewConditionLike(NodeCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints != null ? (NodeDaemonEndpoints)this.daemonEndpoints.build() : null;
    }

    @Override
    public T withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
        if (daemonEndpoints != null) {
            this.daemonEndpoints = new NodeDaemonEndpointsBuilder(daemonEndpoints);
            this._visitables.add(this.daemonEndpoints);
        }
        return (T)this;
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<T> withNewDaemonEndpoints() {
        return new DaemonEndpointsNestedImpl();
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<T> withNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return new DaemonEndpointsNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<T> editDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints());
    }

    @Override
    public T addToImages(ContainerImage ... items) {
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromImages(ContainerImage ... items) {
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.remove(builder);
            this.images.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ContainerImage> getImages() {
        return this.build(this.images);
    }

    @Override
    public T withImages(List<ContainerImage> images) {
        this.images.clear();
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withImages(ContainerImage ... images) {
        this.images.clear();
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (T)this;
    }

    @Override
    public NodeStatusFluent.ImagesNested<T> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public NodeStatusFluent.ImagesNested<T> addNewImageLike(ContainerImage item) {
        return new ImagesNestedImpl(item);
    }

    @Override
    public NodeSystemInfo getNodeInfo() {
        return this.nodeInfo != null ? (NodeSystemInfo)this.nodeInfo.build() : null;
    }

    @Override
    public T withNodeInfo(NodeSystemInfo nodeInfo) {
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.add(this.nodeInfo);
        }
        return (T)this;
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<T> withNewNodeInfo() {
        return new NodeInfoNestedImpl();
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<T> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<T> editNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo());
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public T withPhase(String phase) {
        this.phase = phase;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStatusFluentImpl that = (NodeStatusFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.allocatable != null ? !this.allocatable.equals(that.allocatable) : that.allocatable != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.daemonEndpoints != null ? !this.daemonEndpoints.equals(that.daemonEndpoints) : that.daemonEndpoints != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.nodeInfo != null ? !this.nodeInfo.equals(that.nodeInfo) : that.nodeInfo != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class NodeInfoNestedImpl<N>
    extends NodeSystemInfoFluentImpl<NodeStatusFluent.NodeInfoNested<N>>
    implements NodeStatusFluent.NodeInfoNested<N> {
        private final NodeSystemInfoBuilder builder;

        NodeInfoNestedImpl() {
            this.builder = new NodeSystemInfoBuilder(this);
        }

        NodeInfoNestedImpl(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withNodeInfo(this.builder.build());
        }

        @Override
        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ContainerImageFluentImpl<NodeStatusFluent.ImagesNested<N>>
    implements NodeStatusFluent.ImagesNested<N> {
        private final ContainerImageBuilder builder;

        ImagesNestedImpl() {
            this.builder = new ContainerImageBuilder(this);
        }

        ImagesNestedImpl(ContainerImage item) {
            this.builder = new ContainerImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.addToImages(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class DaemonEndpointsNestedImpl<N>
    extends NodeDaemonEndpointsFluentImpl<NodeStatusFluent.DaemonEndpointsNested<N>>
    implements NodeStatusFluent.DaemonEndpointsNested<N> {
        private final NodeDaemonEndpointsBuilder builder;

        DaemonEndpointsNestedImpl() {
            this.builder = new NodeDaemonEndpointsBuilder(this);
        }

        DaemonEndpointsNestedImpl(NodeDaemonEndpoints item) {
            this.builder = new NodeDaemonEndpointsBuilder(this, item);
        }

        @Override
        public N endDaemonEndpoints() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withDaemonEndpoints(this.builder.build());
        }
    }

    public class ConditionsNestedImpl<N>
    extends NodeConditionFluentImpl<NodeStatusFluent.ConditionsNested<N>>
    implements NodeStatusFluent.ConditionsNested<N> {
        private final NodeConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new NodeConditionBuilder(this);
        }

        ConditionsNestedImpl(NodeCondition item) {
            this.builder = new NodeConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.addToConditions(this.builder.build());
        }
    }

    public class AddressesNestedImpl<N>
    extends NodeAddressFluentImpl<NodeStatusFluent.AddressesNested<N>>
    implements NodeStatusFluent.AddressesNested<N> {
        private final NodeAddressBuilder builder;

        AddressesNestedImpl() {
            this.builder = new NodeAddressBuilder(this);
        }

        AddressesNestedImpl(NodeAddress item) {
            this.builder = new NodeAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.addToAddresses(this.builder.build());
        }

        @Override
        public N endAddresse() {
            return this.and();
        }
    }
}

