/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PersistentVolumeSpecBuilder
extends PersistentVolumeSpecFluentImpl<PersistentVolumeSpecBuilder>
implements VisitableBuilder<PersistentVolumeSpec, PersistentVolumeSpecBuilder> {
    PersistentVolumeSpecFluent<?> fluent;

    public PersistentVolumeSpecBuilder() {
        this(new PersistentVolumeSpec());
    }

    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent) {
        this(fluent, new PersistentVolumeSpec());
    }

    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent, PersistentVolumeSpec instance) {
        this.fluent = fluent;
        fluent.withAccessModes(instance.getAccessModes());
        fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        fluent.withCapacity(instance.getCapacity());
        fluent.withCephfs(instance.getCephfs());
        fluent.withCinder(instance.getCinder());
        fluent.withClaimRef(instance.getClaimRef());
        fluent.withFc(instance.getFc());
        fluent.withFlexVolume(instance.getFlexVolume());
        fluent.withFlocker(instance.getFlocker());
        fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
        fluent.withGlusterfs(instance.getGlusterfs());
        fluent.withHostPath(instance.getHostPath());
        fluent.withIscsi(instance.getIscsi());
        fluent.withNfs(instance.getNfs());
        fluent.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
        fluent.withRbd(instance.getRbd());
    }

    public PersistentVolumeSpecBuilder(PersistentVolumeSpec instance) {
        this.fluent = this;
        this.withAccessModes(instance.getAccessModes());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withCapacity(instance.getCapacity());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withClaimRef(instance.getClaimRef());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
        this.withRbd(instance.getRbd());
    }

    @Override
    public EditablePersistentVolumeSpec build() {
        EditablePersistentVolumeSpec buildable = new EditablePersistentVolumeSpec(this.fluent.getAccessModes(), this.fluent.getAwsElasticBlockStore(), this.fluent.getCapacity(), this.fluent.getCephfs(), this.fluent.getCinder(), this.fluent.getClaimRef(), this.fluent.getFc(), this.fluent.getFlexVolume(), this.fluent.getFlocker(), this.fluent.getGcePersistentDisk(), this.fluent.getGlusterfs(), this.fluent.getHostPath(), this.fluent.getIscsi(), this.fluent.getNfs(), this.fluent.getPersistentVolumeReclaimPolicy(), this.fluent.getRbd());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeSpecBuilder that = (PersistentVolumeSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

