/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableSecretKeySelector;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.model.SecretKeySelectorFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecretKeySelectorBuilder
extends SecretKeySelectorFluentImpl<SecretKeySelectorBuilder>
implements VisitableBuilder<SecretKeySelector, SecretKeySelectorBuilder> {
    SecretKeySelectorFluent<?> fluent;

    public SecretKeySelectorBuilder() {
        this(new SecretKeySelector());
    }

    public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent) {
        this(fluent, new SecretKeySelector());
    }

    public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent, SecretKeySelector instance) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withName(instance.getName());
    }

    public SecretKeySelectorBuilder(SecretKeySelector instance) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withName(instance.getName());
    }

    @Override
    public EditableSecretKeySelector build() {
        EditableSecretKeySelector buildable = new EditableSecretKeySelector(this.fluent.getKey(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretKeySelectorBuilder that = (SecretKeySelectorBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

