/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableHTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HTTPIngressPathBuilder
extends HTTPIngressPathFluentImpl<HTTPIngressPathBuilder>
implements VisitableBuilder<HTTPIngressPath, HTTPIngressPathBuilder> {
    HTTPIngressPathFluent<?> fluent;

    public HTTPIngressPathBuilder() {
        this(new HTTPIngressPath());
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
        this(fluent, new HTTPIngressPath());
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, HTTPIngressPath instance) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withPath(instance.getPath());
    }

    public HTTPIngressPathBuilder(HTTPIngressPath instance) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withPath(instance.getPath());
    }

    @Override
    public EditableHTTPIngressPath build() {
        EditableHTTPIngressPath buildable = new EditableHTTPIngressPath(this.fluent.getBackend(), this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressPathBuilder that = (HTTPIngressPathBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

