package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface BindingFluent<T extends BindingFluent<T>> extends Fluent<T>{


    public Binding.ApiVersion getApiVersion();    public T withApiVersion( Binding.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ObjectReference getTarget();    public T withTarget( ObjectReference target);    public TargetNested<T> withNewTarget();    public TargetNested<T> withNewTargetLike( ObjectReference item);    public TargetNested<T> editTarget();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface TargetNested<N> extends Nested<N>, ObjectReferenceFluent<TargetNested<N>>{
            public N and();            public N endTarget();        
}


}
