package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;

public class ComponentStatusFluentImpl<T extends ComponentStatusFluent<T>> extends BaseFluent<T> implements ComponentStatusFluent<T>{

     ComponentStatus.ApiVersion apiVersion;     List<VisitableBuilder<ComponentCondition, ?>> conditions = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();
public ComponentStatusFluentImpl(){
    
}
public ComponentStatusFluentImpl( ComponentStatus instance ){
    this.withApiVersion(instance.getApiVersion()); this.withConditions(instance.getConditions()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public ComponentStatus.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ComponentStatus.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToConditions( ComponentCondition ...items){
    for (ComponentCondition item : items) {ComponentConditionBuilder builder = new ComponentConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (T)this;
    }
    public T removeFromConditions( ComponentCondition ...items){
    for (ComponentCondition item : items) {ComponentConditionBuilder builder = new ComponentConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (T)this;
    }
    public List<ComponentCondition> getConditions(){
    return build(conditions);
    }
    public T withConditions( List<ComponentCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (ComponentCondition item : conditions){this.addToConditions(item);}} return (T) this;
    }
    public T withConditions( ComponentCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (ComponentCondition item :conditions){ this.addToConditions(item);}} return (T) this;
    }
    public ConditionsNested<T> addNewCondition(){
    return new ConditionsNestedImpl<T>();
    }
    public ConditionsNested<T> addNewConditionLike( ComponentCondition item){
    return new ConditionsNestedImpl<T>(item);
    }
    public T addNewCondition( String error,  String message,  String status,  String type){
    return addToConditions(new ComponentCondition(error, message, status, type));
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ComponentStatusFluentImpl that = (ComponentStatusFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends ComponentConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final ComponentConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new ComponentConditionBuilder(this);
        }
             ConditionsNestedImpl ( ComponentCondition item){
        this.builder = new ComponentConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) ComponentStatusFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ComponentStatusFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
