package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class DoneableVolume extends VolumeFluentImpl<DoneableVolume> implements Doneable<Volume>, VolumeFluent<DoneableVolume>{


    private final VolumeBuilder builder;    private final Function<Volume, Volume> function;
    public DoneableVolume ( Function<Volume, Volume> function){
    this.builder=new VolumeBuilder(this);this.function=function;
}
    public DoneableVolume ( Volume item,  Function<Volume, Volume> function){
    this.builder=new VolumeBuilder(this, item);this.function=function;
}
    public DoneableVolume ( Volume item){
    this.builder=new VolumeBuilder(this, item);this.function=new Function<Volume, Volume>() {
    public Volume apply(Volume item) {
        return item;
    }
}
;
}

    public Volume done(){
     return function.apply(builder.build());
}


}
