package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class FCVolumeSourceFluentImpl<T extends FCVolumeSourceFluent<T>> extends BaseFluent<T> implements FCVolumeSourceFluent<T>{

     String fsType;     Integer lun;     Boolean readOnly;     List<String> targetWWNs = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public FCVolumeSourceFluentImpl(){
    
}
public FCVolumeSourceFluentImpl( FCVolumeSource instance ){
    this.withFsType(instance.getFsType()); this.withLun(instance.getLun()); this.withReadOnly(instance.getReadOnly()); this.withTargetWWNs(instance.getTargetWWNs()); 
}

    public String getFsType(){
    return this.fsType;
    }
    public T withFsType( String fsType){
    this.fsType=fsType; return (T) this;
    }
    public Integer getLun(){
    return this.lun;
    }
    public T withLun( Integer lun){
    this.lun=lun; return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public T addToTargetWWNs( String ...items){
    for (String item : items) {this.targetWWNs.add(item);} return (T)this;
    }
    public T removeFromTargetWWNs( String ...items){
    for (String item : items) {this.targetWWNs.remove(item);} return (T)this;
    }
    public List<String> getTargetWWNs(){
    return this.targetWWNs;
    }
    public T withTargetWWNs( List<String> targetWWNs){
    this.targetWWNs.clear();if (targetWWNs != null) {for (String item : targetWWNs){this.addToTargetWWNs(item);}} return (T) this;
    }
    public T withTargetWWNs( String ...targetWWNs){
    this.targetWWNs.clear(); if (targetWWNs != null) {for (String item :targetWWNs){ this.addToTargetWWNs(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
FCVolumeSourceFluentImpl that = (FCVolumeSourceFluentImpl) o;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (lun != null ? !lun.equals(that.lun) :that.lun != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (targetWWNs != null ? !targetWWNs.equals(that.targetWWNs) :that.targetWWNs != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
