package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface FlexVolumeSourceFluent<T extends FlexVolumeSourceFluent<T>> extends Fluent<T>{


    public String getDriver();    public T withDriver( String driver);    public String getFsType();    public T withFsType( String fsType);    public T addToOptions( String key,  String value);    public T addToOptions( Map<String, String> map);    public T removeFromOptions( String key);    public T removeFromOptions( Map<String, String> map);    public Map<String, String> getOptions();    public T withOptions( Map<String, String> options);    public Boolean isReadOnly();    public T withReadOnly( Boolean readOnly);    public LocalObjectReference getSecretRef();    public T withSecretRef( LocalObjectReference secretRef);    public SecretRefNested<T> withNewSecretRef();    public SecretRefNested<T> withNewSecretRefLike( LocalObjectReference item);    public SecretRefNested<T> editSecretRef();    public T withNewSecretRef( String name);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SecretRefNested<N> extends Nested<N>, LocalObjectReferenceFluent<SecretRefNested<N>>{
            public N endSecretRef();            public N and();        
}


}
