package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class GCEPersistentDiskVolumeSourceBuilder extends GCEPersistentDiskVolumeSourceFluentImpl<GCEPersistentDiskVolumeSourceBuilder> implements VisitableBuilder<GCEPersistentDiskVolumeSource,GCEPersistentDiskVolumeSourceBuilder>{

     GCEPersistentDiskVolumeSourceFluent<?> fluent;
public GCEPersistentDiskVolumeSourceBuilder(){
    this(new GCEPersistentDiskVolumeSource());
}
public GCEPersistentDiskVolumeSourceBuilder( GCEPersistentDiskVolumeSourceFluent<?> fluent ){
    this(fluent, new GCEPersistentDiskVolumeSource());
}
public GCEPersistentDiskVolumeSourceBuilder( GCEPersistentDiskVolumeSourceFluent<?> fluent , GCEPersistentDiskVolumeSource instance ){
    this.fluent = fluent; fluent.withFsType(instance.getFsType()); fluent.withPartition(instance.getPartition()); fluent.withPdName(instance.getPdName()); fluent.withReadOnly(instance.getReadOnly()); 
}
public GCEPersistentDiskVolumeSourceBuilder( GCEPersistentDiskVolumeSource instance ){
    this.fluent = this; this.withFsType(instance.getFsType()); this.withPartition(instance.getPartition()); this.withPdName(instance.getPdName()); this.withReadOnly(instance.getReadOnly()); 
}

public EditableGCEPersistentDiskVolumeSource build(){
    EditableGCEPersistentDiskVolumeSource buildable = new EditableGCEPersistentDiskVolumeSource(fluent.getFsType(),fluent.getPartition(),fluent.getPdName(),fluent.isReadOnly());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
GCEPersistentDiskVolumeSourceBuilder that = (GCEPersistentDiskVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
