package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ReplicationControllerStatusFluentImpl<T extends ReplicationControllerStatusFluent<T>> extends BaseFluent<T> implements ReplicationControllerStatusFluent<T>{

     Long observedGeneration;     Integer replicas;     Map<String, Object> additionalProperties = new HashMap();
public ReplicationControllerStatusFluentImpl(){
    
}
public ReplicationControllerStatusFluentImpl( ReplicationControllerStatus instance ){
    this.withObservedGeneration(instance.getObservedGeneration()); this.withReplicas(instance.getReplicas()); 
}

    public Long getObservedGeneration(){
    return this.observedGeneration;
    }
    public T withObservedGeneration( Long observedGeneration){
    this.observedGeneration=observedGeneration; return (T) this;
    }
    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ReplicationControllerStatusFluentImpl that = (ReplicationControllerStatusFluentImpl) o;
if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
